;
;
;		Lib for DOLMEN-XBIOS (rev. 1)
;
;		with Turbo/Pure C parameter passing (d0-d2/a0-a1)
;
;		Last update: 20.02.98			by David REN
;
	
	.EXPORT			Vread			; pour connatre le mode vido en cours.
	.EXPORT			Vwrite		; pour changer les rsolutions.
	.EXPORT	    Vattrib		; modifie les attributs d'un mode vido.
	.EXPORT	    Vcreate		;	ajoute un nouveau mode vido.
	.EXPORT	    Vdelete		; efface un mode vido.
	.EXPORT	    Vfirst		; fournit les paramtres du premier mode vido disponible.
	.EXPORT	    Vnext			; fournit le mode suivant.
	.EXPORT	    Vvalid		; vrifie l'intgrit d'un mode vido.
	.EXPORT	    Vload			; recharge le VIDEO.DAT.
	.EXPORT	    Vsave			; sauve les paramtres vido dans le VIDEO.DAT.
	.EXPORT	    Vopen			; Rveille l'cran.
	.EXPORT	    Vclose		; Eteint l'cran.
	.EXPORT	    Vscroll		; Fixe la mthode de scrolling.
	.EXPORT	    Voffset		; Position de l'cran virtuel.
	.EXPORT	    Vseek			; Positionne l'cran virtuel
	.EXPORT	    Vlock			; Bloque l'cran virtuel.
	.EXPORT	    SetMon		; Modifie le type de moniteur.
	.EXPORT	    MultiMon	; Mode multisynchro.
	.EXPORT	    SizeComp	; Compatibilit de Vgetsize.
	.EXPORT	    VmodeValid	; Compatibilit de Vgetsize.


VREAD 			equ	65
VWRITE  		equ	66
VATTRIB			equ	67
VCREATE			equ	68
VDELETE			equ	69
VFIRST			equ	70
VNEXT				equ	71
VVALID			equ	72
VLOAD				equ	73
VSAVE				equ	74
VOPEN				equ	75
VCLOSE			equ	76
VSCROLL			equ	77
VOFFSET			equ	78
VSEEK				equ	79
VLOCK				equ	80
SETMON			equ	81
MULTIMON		equ	82
SIZECOMP		equ	83
VMODEVALID	equ	95


MACRO	CALLDRVR num
	move.w	#(num),-(sp)
	trap	#14
ENDM

	.TEXT

MODULE	Vread:

		move.l		a2,-(sp)		; sauve A2
		move.l		a0,-(sp)
		CALLDRVR	VREAD
		lea				6(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vwrite:

		move.l		a2,-(sp)		; sauve A2
		move.l		a1,-(sp)		;	Pointeur sur OutParam
		move.l		a0,-(sp)		; Pointeur sur InParam
		move.w		d0,-(sp)		; InitVDI
		CALLDRVR	VWRITE
		lea				12(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vattrib:

		move.l		a2,-(sp)		; sauve A2
		move.l		a1,-(sp)		;	Pointeur sur OutParam
		move.l		a0,-(sp)		; Pointeur sur InParam
		CALLDRVR	VATTRIB
		lea				10(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vcreate:

		move.l		a2,-(sp)		; sauve A2
		move.l		a1,-(sp)		;	Pointeur sur OutParam
		move.l		a0,-(sp)		; Pointeur sur InParam
		CALLDRVR	VCREATE
		lea				10(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vdelete:

		move.l		a2,-(sp)		; sauve A2
		move.w		d0,-(sp)		; Pointeur sur InParam
		CALLDRVR	VDELETE
		lea				4(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vfirst:

		move.l		a2,-(sp)		; sauve A2
		move.l		a1,-(sp)		; Pointeur sur InParam
		move.l		a0,-(sp)		; Pointeur sur InParam
		CALLDRVR	VFIRST
		lea				10(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vnext:

		move.l		a2,-(sp)		; sauve A2
		move.l		a1,-(sp)		; Pointeur sur InParam
		move.l		a0,-(sp)		; Pointeur sur InParam
		CALLDRVR	VNEXT
		lea				10(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vvalid:

		move.l		a2,-(sp)		; sauve A2
		move.w		d0,-(sp)		; Pointeur sur InParam
		CALLDRVR	VVALID
		lea				4(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vload:

		move.l		a2,-(sp)		; sauve A2
		CALLDRVR	VLOAD
		lea				2(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vsave:

		move.l		a2,-(sp)		; sauve A2
		CALLDRVR	VSAVE
		lea				2(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vopen:

		move.l		a2,-(sp)		; sauve A2
		CALLDRVR	VOPEN
		lea				2(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vclose:

		move.l		a2,-(sp)		; sauve A2
		CALLDRVR	VCLOSE
		lea				2(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vscroll:

		move.l		a2,-(sp)		; sauve A2
		move.w		d0,-(sp)		;	ScrollMode
		CALLDRVR	VSCROLL
		lea				4(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Voffset:

		move.l		a2,-(sp)		; sauve A2
		CALLDRVR	VOFFSET
		lea				2(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vseek:

		move.l		a2,-(sp)		; sauve A2
		move.w		d1,-(sp)
		move.w		d0,-(sp)
		CALLDRVR	VSEEK
		lea				6(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	Vlock:

		move.l		a2,-(sp)		; sauve A2
		move.w		d0,-(sp)
		CALLDRVR	VLOCK
		lea				4(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	SetMon:

		move.l		a2,-(sp)		; sauve A2
		move.w		d0,-(sp)
		CALLDRVR	SETMON
		lea				4(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	MultiMon:

		move.l		a2,-(sp)		; sauve A2
		move.w		d0,-(sp)
		CALLDRVR	MULTIMON
		lea				4(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	SizeComp:

		move.l		a2,-(sp)		; sauve A2
		move.w		d0,-(sp)
		CALLDRVR	SIZECOMP
		lea				4(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

MODULE	VmodeValid:

		move.l		a2,-(sp)		; sauve A2
		move.w		d0,-(sp)
		CALLDRVR	VMODEVALID
		lea				4(sp),sp		; corrige la pile
		move.l		(sp)+,a2		; restore A2
		rts

ENDMOD

	.END
